# transform.sh param1-dir(input) param2-dmg(input) 
#              param1-dir : the directory that contains the branding input files. which we will define. 
#              param2-dmg : the input dmg file that was released by Gladinet.
#              param3-pkg : the output dmg file that can be used.  - this is optional , if omit, it can be auto-generated.
readonly PARAM1_DIR=$1
readonly PARAM2_DMG=$2

readonly PARAM3_KG=$3

readonly PLISTBUDDY="/usr/libexec/PlistBuddy"

readonly SIGN_APP_STR="Developer ID Application: Gladinet, Inc. (CX8U2YJ96P)"
readonly SIGN_PKG_STR="Developer ID Installer: Gladinet, Inc."

readonly CURRENT_DIR=`pwd`
readonly BUILD_DIR="$CURRENT_DIR/build"
readonly INSTALLER_DIR="$BUILD_DIR/installer_dir"
readonly PAYLOAD_DIR="$BUILD_DIR/payload_dir"


declare m_stderr=/dev/stderr
declare m_stdout=/dev/stdout

function m_exit_on_error()
{
    if [ "$?" != 0 ]
    then
        local retval=$?
        echo "transform failed: $1" 1>&2
        exit $retval
    fi

    # NOTREACHED
}


cd "$PARAM1_DIR"
readonly PARAM1_DIR_ABSOLUTE=`pwd`
cd "$CURRENT_DIR"

declare m_srcroot="$PARAM1_DIR_ABSOLUTE"



# all the temporary folder will be under build/outpkgdir and build/inpkgdir
if [ -d "$BUILD_DIR" ]; then
  # Control will enter here if $DIRECTORY exists.
  rm -rf "$BUILD_DIR"
fi

if [ ! -d "$PARAM1_DIR" ]; then
    false
    m_exit_on_error "input branding directory not found!"
    exit 1
fi



readonly branding_info_file=$PARAM1_DIR_ABSOLUTE/common.sh

if [ ! -f "$branding_info_file" ]; then
    false
    m_exit_on_error "input branding common.sh file not found!"
    exit 1
fi

source "$branding_info_file"


if [ ! -f "$PARAM2_DMG" ]; then
    false
    m_exit_on_error "input pkg file not found!"
    exit 1
fi

hdiutil attach -private -nobrowse "$PARAM2_DMG" >$m_stdout 2>$m_stderr
m_exit_on_error "cannot attach Installer disk image."

declare md_volume_name="Cloud Drive Installer"
declare md_volume_path="/Volumes/$md_volume_name"

declare PARAM2_PKG_SEARCH=""

cd "$md_volume_path"
for pkgfile in *.pkg
do
    PARAM2_PKG_SEARCH=$pkgfile
    break
done

cd "$CURRENT_DIR"

readonly PARAM2_PKG=input.pkg

cp -f "$md_volume_path/$PARAM2_PKG_SEARCH" "$PARAM2_PKG"

hdiutil detach "$md_volume_path" >$m_stdout 2>$m_stderr


mkdir -p "$PAYLOAD_DIR"



# input will be a package .pkg and we will expand it to a folder at $INSTALLER_DIR
function installer_expand()
{
    local installerPkg=$1
    local targetDir=$2

    pwd

    pkgutil --expand "$installerPkg" "$targetDir"
    m_exit_on_error "Couldn't expand package"
}

function installer_collapse()
{
    local targetDir=$1
    local targetPkg=$2

	pkgutil --flatten "$targetDir" "$targetPkg"
	productsign --sign "$SIGN_PKG_STR" "$targetPkg" "${targetPkg/.pkg/_sign.pkg}"
    echo "${targetPkg/.pkg/_sign.pkg}"

}

function pkg_expand()
{
    echo "$M_WARNING: $*"
}

function pkg_collapse()
{
    echo "$M_WARNING: $*"
}

installer_expand "$PARAM2_PKG" "$INSTALLER_DIR"

# replace background.png

readonly bra_background_png="$PARAM1_DIR_ABSOLUTE/background.png"

readonly pkg_bacnground_png="$INSTALLER_DIR/Resources/background.png"
if [ -f "$bra_background_png" ]; then
    chmod +w "$pkg_bacnground_png"
    cp -f "$bra_background_png" "$pkg_bacnground_png"
fi

# replace License.rtf Localizable.strings

readonly bra_license_rtf="$PARAM1_DIR_ABSOLUTE/License.rtf"

readonly pkg_license_rtf="$INSTALLER_DIR/Resources/English.lproj/License.rtf"
if [ -f "$bra_license_rtf" ]; then
    chmod +w "$pkg_license_rtf"
    cp -f "$bra_license_rtf" "$pkg_license_rtf"
fi

# replace Welcome.rtf

readonly bra_welcome_rtf="$PARAM1_DIR_ABSOLUTE/Welcome.rtf"

readonly pkg_welcome_rtf="$INSTALLER_DIR/Resources/English.lproj/Welcome.rtf"
if [ -f "$bra_welcome_rtf" ]; then
    chmod +w "$pkg_welcome_rtf"
    cp -f "$bra_welcome_rtf" "$pkg_welcome_rtf"
fi

# replace Localizable.strings, it is UTF16LE byte order mark in the text file. 
# but shell only work with utf8. so need iconv
readonly pkg_local_str="$INSTALLER_DIR/Resources/English.lproj/Localizable.strings"
readonly pkg_temp_str="$INSTALLER_DIR/Resources/English.lproj/Localizable.strings_temp"
cat "$pkg_local_str"
chmod +w "$pkg_local_str"
mv "$pkg_local_str" "$pkg_temp_str" 
iconv -f UTF-16LE -t UTF-8 "$pkg_temp_str" > "$pkg_local_str"
rm "$pkg_temp_str"

perl -pi -e "s/\"GLADINETCLIENT_TITLE\".*$/\"GLADINETCLIENT_TITLE\" = \"$CLIENT_TITLE\";/" "$pkg_local_str"
perl -pi -e "s/\"GLADINETCLIENT_DESCRIPTION\".*$/\"GLADINETCLIENT_DESCRIPTION\" = \"$CLIENT_DESCRIPTION\";/" "$pkg_local_str"

mv "$pkg_local_str" "$pkg_temp_str" 
iconv -f UTF-8 -t UTF-16LE "$pkg_temp_str" > "$pkg_local_str"
rm "$pkg_temp_str"

# replace <title>HelloWorld Mac Client</title> in Distribution
# todo: may need to encoude &
readonly pkg_dist_file="$INSTALLER_DIR/Distribution"
chmod +w "$pkg_dist_file"
perl -pi -e "s/<title>[^<]*<\/title>/<title>$CLIENT_TITLE<\/title>/g" "$pkg_dist_file"


# now go deeper into the pkg file
# build/installer_dir/GladinetClient.pkg/Payload
readonly pkg_gladinet_payload="$INSTALLER_DIR/GladinetClient.pkg/Payload"
cd "$PAYLOAD_DIR"
cat "$pkg_gladinet_payload" | gzip -d | cpio -id

#Let's rename the app. 

readonly old_app_name="Cloud Drive.app"

readonly new_app_name="$CLIENT_TITLE.app"
for file in *.app
do
    if [ "$file" != "$new_app_name" ]
    then
        mv "$file" "$new_app_name"
        break
    fi
done
#mv "$old_app_name" "$new_app_name"

# now let's replace some stuff 
# /Users/jerry/testpkg/build/payload_dir/Privatier Cloud Mac Client.app/Contents/Resources
readonly PLIST_FILE="$PAYLOAD_DIR/$new_app_name/Contents/Info.plist"
chmod +w "$PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleName '$CLIENT_TITLE'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CSAccessPoint '$FULL_ACCESS_POINT'" "$PLIST_FILE"

# appicon 16x16
readonly appicon_16x16_png_tar="$PAYLOAD_DIR/$new_app_name/Contents/Resources/3color-all.png"

readonly appicon_16x16_png_src="$PARAM1_DIR_ABSOLUTE/appicon16.png"

if [ -f "$appicon_16x16_png_src" ]; then
    chmod +w "$appicon_16x16_png_tar"
    cp -f "$appicon_16x16_png_src" "$appicon_16x16_png_tar"
fi

# appicon 188x188
readonly appicon_188_png_tar="$PAYLOAD_DIR/$new_app_name/Contents/Resources/appicon188.png"

readonly appicon_188_png_src="$PARAM1_DIR_ABSOLUTE/appicon188.png"

if [ -f "$appicon_188_png_src" ]; then
    chmod +w "$appicon_188_png_tar"
    cp -f "$appicon_188_png_src" "$appicon_188_png_tar"
fi


# appicon.icns
readonly appicon_512_icns_tar="$PAYLOAD_DIR/$new_app_name/Contents/Resources/appicon.icns"

readonly appicon_512_icns_src="$PARAM1_DIR_ABSOLUTE/appicon512.icns"

if [ -f "$appicon_512_icns_src" ]; then
    chmod +w "$appicon_512_icns_tar"
    cp -f "$appicon_512_icns_src" "$appicon_512_icns_tar"
fi

# upload1.ico
readonly upload1_ico_tar="$PAYLOAD_DIR/$new_app_name/Contents/Resources/upload1.ico"

readonly upload1_ico_src="$PARAM1_DIR_ABSOLUTE/upload1.ico"

if [ -f "$upload1_ico_src" ]; then
    chmod +w "$upload1_ico_tar"
    cp -f "$upload1_ico_src" "$upload1_ico_tar"
fi

# upload2.ico
readonly upload2_ico_tar="$PAYLOAD_DIR/$new_app_name/Contents/Resources/upload2.ico"

readonly upload2_ico_src="$PARAM1_DIR_ABSOLUTE/upload2.ico"

if [ -f "$upload2_ico_src" ]; then
    chmod +w "$upload2_ico_tar"
    cp -f "$upload2_ico_src" "$upload2_ico_tar"
fi

# upload3.ico
readonly upload3_ico_tar="$PAYLOAD_DIR/$new_app_name/Contents/Resources/upload3.ico"

readonly upload3_ico_src="$PARAM1_DIR_ABSOLUTE/upload3.ico"

if [ -f "$upload3_ico_src" ]; then
    chmod +w "$upload3_ico_tar"
    cp -f "$upload3_ico_src" "$upload3_ico_tar"
fi

# upload4.ico
readonly upload4_ico_tar="$PAYLOAD_DIR/$new_app_name/Contents/Resources/upload4.ico"

readonly upload4_ico_src="$PARAM1_DIR_ABSOLUTE/upload4.ico"

if [ -f "$upload4_ico_src" ]; then
    chmod +w "$upload4_ico_tar"
    cp -f "$upload4_ico_src" "$upload4_ico_tar"
fi

# notconn.ico
readonly notconn_ico_tar="$PAYLOAD_DIR/$new_app_name/Contents/Resources/notconn.ico"

readonly notconn_ico_src="$PARAM1_DIR_ABSOLUTE/notconn.ico"

if [ -f "$notconn_ico_src" ]; then
    chmod +w "$notconn_ico_tar"
    cp -f "$notconn_ico_src" "$notconn_ico_tar"
fi

# now let's clear the infoPlist.strings
readonly infoString_en="$PAYLOAD_DIR/$new_app_name/Contents/Resources/en.lproj/InfoPlist.strings"
echo -n "" > "$infoString_en"

readonly infoString_ja="$PAYLOAD_DIR/$new_app_name/Contents/Resources/ja.lproj/InfoPlist.strings"
echo -n "" > "$infoString_ja"


readonly infoString_zh="$PAYLOAD_DIR/$new_app_name/Contents/Resources/zh-Hans.lproj/InfoPlist.strings"
echo -n "" > "$infoString_zh"



# now we use plist buddy to change plist.

# we will sign the new app
codesign -f -s "$SIGN_APP_STR" "$new_app_name/"

# re-generate the Payload
rm "$pkg_gladinet_payload"
cd "$PAYLOAD_DIR"
find . | cpio -o --format odc | gzip -c > "$pkg_gladinet_payload"

# re-create the BOM - bill of material file
readonly pkg_gladinet_bom="$INSTALLER_DIR/GladinetClient.pkg/Bom"
rm "$pkg_gladinet_bom"
mkbom "$PAYLOAD_DIR" "$pkg_gladinet_bom"

#now update block size
readonly BLOCK_SIZE=`du -sk "$PAYLOAD_DIR" | cut -f 1,1`
readonly NUMBER_FILE=`find "$PAYLOAD_DIR" | wc -l | sed 's/ //g'`

readonly pkg_gladinet_pkginfo="$INSTALLER_DIR/GladinetClient.pkg/PackageInfo"

#now replace <payload installKBytes="1980" numberOfFiles="108"/>
chmod +w "$pkg_gladinet_pkginfo"
perl -pi -e "s/<payload>.*\/>/<payload installKBytes=\"$BLOCK_SIZE\" numberOfFiles=\"$NUMBER_FILE\"\/>/" "$pkg_gladinet_pkginfo"
perl -pi -e "s/$old_app_name/$new_app_name/g" "$pkg_gladinet_pkginfo"


# now re-package everything
cd "$CURRENT_DIR"

if [ -f "output.pkg" ]; then
    rm -f output.pkg
fi

declare signedpkg=output_sign.pkg
installer_collapse "$INSTALLER_DIR" output.pkg


function recreate_dmg()
{
# Create the distribution volume
    #
    local md_volume_name="$CLIENT_TITLE"
    local md_scratch_dmg="installer-scratch.dmg"

    if [ -f "$md_scratch_dmg" ]; then
        rm -f $md_scratch_dmg
    fi

    hdiutil create -layout NONE -size 10m -fs HFS+ -fsargs "-c c=64,a=16,e=16" \
        -volname "$md_volume_name" "$md_scratch_dmg" >$m_stdout 2>$m_stderr
    m_exit_on_error "cannot create scratch installer disk image."

    # Attach/mount the volume
    #
    hdiutil attach -private -nobrowse "$md_scratch_dmg" >$m_stdout 2>$m_stderr
    m_exit_on_error "cannot attach scratch installer disk image."

    local md_volume_path="/Volumes/$md_volume_name"

    /bin/chmod 755 "${md_volume_path}/.Trashes" >$m_stdout 2>$m_stderr && \
    /bin/rm -rf "${md_volume_path}/.Trashes" >$m_stdout 2>$m_stderr
    m_exit_on_error "cannot remove .Trashes directory from scratch disk image"


    # Copy over the package
    #
    local md_pkgname_installer="Install $CLIENT_TITLE.pkg"
    cp -pRX "$signedpkg" "$md_volume_path/$md_pkgname_installer"
    if [ $? -ne 0 ]
    then
        hdiutil detach "$md_volume_path" >$m_stdout 2>$m_stderr
        false
        m_exit_on_error "cannot copy '$M_PKGNAME_OSXFUSE' to scratch disk image."
    fi

    xcrun SetFile -a E "$md_volume_path/$md_pkgname_installer"
    if [ $? -ne 0 ]
    then
        hdiutil detach "$md_volume_path" >$m_stdout 2>$m_stderr
        false
        m_exit_on_error "cannot hide extension of installer package."
    fi



    # Create the .engine_install file
    #
    local md_engine_install="$md_volume_path/.engine_install"
    cat > "$md_engine_install" <<__END_ENGINE_INSTALL
#!/bin/sh -p
/usr/sbin/installer -pkg "\$1/$md_pkgname_installer" -target /
__END_ENGINE_INSTALL

    chmod +x "$md_engine_install"
    m_exit_on_error "cannot set permissions on autoinstaller engine file."


    # Set the custom icon
    #
    cp -pRX "$m_srcroot/appicon512.icns" \
        "$md_volume_path/.VolumeIcon.icns"
    if [ $? -ne 0 ]
    then
        hdiutil detach "$md_volume_path" >$m_stdout 2>$m_stderr
        false
        m_exit_on_error "cannot copy custom volume icon to scratch disk image."
    fi

    xcrun SetFile -a C "$md_volume_path"
    if [ $? -ne 0 ]
    then
        hdiutil detach "$md_volume_path" >$m_stdout 2>$m_stderr
        false
        m_exit_on_error "cannot set custom volume icon on scratch disk image."
    fi

    # Set custom background
    #
    mkdir "$md_volume_path/.background"
    if [ $? -ne 0 ]
    then
        hdiutil detach "$md_volume_path" >$m_stdout 2>$m_stderr
        false
        m_exit_on_error "cannot make directory '.background' on scratch disk image."
    fi

    cp "$m_srcroot/background_installer.png" "$md_volume_path/.background/"
    if [ $? -ne 0 ]
    then
        hdiutil detach "$md_volume_path" >$m_stdout 2>$m_stderr
        false
        m_exit_on_error "cannot copy background picture to scratch disk image."
    fi

    open -a Finder "$md_volume_path"

    sleep 5
    # Customize scratch image
    #
    echo '
        tell application "Finder"
            tell disk "'$md_volume_name'"
                open
                set current view of container window to icon view
                delay 3
                set toolbar visible of container window to false
                delay 3
                set the bounds of container window to {0, 0, 500, 350}
                delay 3
                set theViewOptions to the icon view options of container window
                delay 3
                set arrangement of theViewOptions to not arranged
                delay 3
                set icon size of theViewOptions to 128
                delay 3
                set background picture of theViewOptions to file ".background:background_installer.png"
                delay 3
           
                set position of item "'$md_pkgname_installer'" of container window to {250, 218}
                delay 3
              
                close
                delay 3
                open
                delay 3
                  set the bounds of container window to {0, 0, 500, 350}
                  delay 3
                close
            end tell
        end tell
    ' | osascript
    if [ $? -ne 0 ]
    then
        hdiutil detach "$md_volume_path" >$m_stdout 2>$m_stderr
        false
        m_exit_on_error "cannot customize the scratch disk image."
    fi

    chmod -Rf go-w "$md_volume_path"
    sync
    sync
    # ignore errors

    # Detach the volume.
    hdiutil detach "$md_volume_path" >$m_stdout 2>$m_stderr
    if [ $? -ne 0 ]
    then
        false
        m_exit_on_error "cannot detach volume '$md_volume_path'."
    fi

    # Convert to a read-only compressed dmg
    #
    local md_dmg_name="Output-$PARAM2_DMG"
    local md_dmg_path="$md_dmg_name"
    hdiutil convert -imagekey zlib-level=9 -format UDZO "$md_scratch_dmg" \
        -o "$md_dmg_path" >$m_stdout 2>$m_stderr
    m_exit_on_error "cannot finalize OSXFUSE distribution disk image."

    rm -f "$md_scratch_dmg"
    echo done, check output file $md_dmg_name
}

recreate_dmg
